/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.SoundType;

public class SoundTypes {
    private static final Map<SoundType, String> TRANSLATION_MAP;

    public static Map<SoundType, String> getTranslationMap() {
        return TRANSLATION_MAP;
    }

    @Nullable
    public static String getName(SoundType soundType) {
        return TRANSLATION_MAP.get(soundType);
    }

    @Nullable
    public static SoundType getSoundType(String name) {
        return TRANSLATION_MAP.entrySet().stream().filter(e -> ((String)e.getValue()).equals(name)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static MutableComponent getNameComponent(SoundType soundType) {
        String name = SoundTypes.getName(soundType);
        if (name == null) {
            return Component.m_237113_((String)"N/A");
        }
        String[] split = name.split("_");
        StringBuilder builder = new StringBuilder();
        for (String s : split) {
            builder.append(s.charAt(0));
            builder.append(s.substring(1).toLowerCase(Locale.ROOT));
            builder.append(" ");
        }
        return Component.m_237113_((String)builder.toString().trim());
    }

    static {
        HashMap<SoundType, String> names = new HashMap<SoundType, String>();
        names.put(SoundType.f_56736_, "WOOD");
        names.put(SoundType.f_56739_, "GRAVEL");
        names.put(SoundType.f_56740_, "GRASS");
        names.put(SoundType.f_56741_, "LILY_PAD");
        names.put(SoundType.f_56742_, "STONE");
        names.put(SoundType.f_56743_, "METAL");
        names.put(SoundType.f_56744_, "GLASS");
        names.put(SoundType.f_56745_, "WOOL");
        names.put(SoundType.f_56746_, "SAND");
        names.put(SoundType.f_56747_, "SNOW");
        names.put(SoundType.f_154681_, "POWDER_SNOW");
        names.put(SoundType.f_56748_, "LADDER");
        names.put(SoundType.f_56749_, "ANVIL");
        names.put(SoundType.f_56750_, "SLIME_BLOCK");
        names.put(SoundType.f_56751_, "HONEY_BLOCK");
        names.put(SoundType.f_56752_, "WET_GRASS");
        names.put(SoundType.f_56753_, "CORAL_BLOCK");
        names.put(SoundType.f_56754_, "BAMBOO");
        names.put(SoundType.f_56755_, "BAMBOO_SAPLING");
        names.put(SoundType.f_56756_, "SCAFFOLDING");
        names.put(SoundType.f_56757_, "SWEET_BERRY_BUSH");
        names.put(SoundType.f_56758_, "CROP");
        names.put(SoundType.f_56759_, "HARD_CROP");
        names.put(SoundType.f_56760_, "VINE");
        names.put(SoundType.f_56761_, "NETHER_WART");
        names.put(SoundType.f_56762_, "LANTERN");
        names.put(SoundType.f_56763_, "STEM");
        names.put(SoundType.f_56710_, "NYLIUM");
        names.put(SoundType.f_56711_, "FUNGUS");
        names.put(SoundType.f_56712_, "ROOTS");
        names.put(SoundType.f_56713_, "SHROOMLIGHT");
        names.put(SoundType.f_56714_, "WEEPING_VINES");
        names.put(SoundType.f_56715_, "TWISTING_VINES");
        names.put(SoundType.f_56716_, "SOUL_SAND");
        names.put(SoundType.f_56717_, "SOUL_SOIL");
        names.put(SoundType.f_56718_, "BASALT");
        names.put(SoundType.f_56719_, "WART_BLOCK");
        names.put(SoundType.f_56720_, "NETHERRACK");
        names.put(SoundType.f_56721_, "NETHER_BRICKS");
        names.put(SoundType.f_56722_, "NETHER_SPROUTS");
        names.put(SoundType.f_56723_, "NETHER_ORE");
        names.put(SoundType.f_56724_, "BONE_BLOCK");
        names.put(SoundType.f_56725_, "NETHERITE_BLOCK");
        names.put(SoundType.f_56726_, "ANCIENT_DEBRIS");
        names.put(SoundType.f_56727_, "LODESTONE");
        names.put(SoundType.f_56728_, "CHAIN");
        names.put(SoundType.f_56729_, "NETHER_GOLD_ORE");
        names.put(SoundType.f_56730_, "GILDED_BLACKSTONE");
        names.put(SoundType.f_154653_, "CANDLE");
        names.put(SoundType.f_154654_, "AMETHYST");
        names.put(SoundType.f_154655_, "AMETHYST_CLUSTER");
        names.put(SoundType.f_154656_, "SMALL_AMETHYST_BUD");
        names.put(SoundType.f_154657_, "MEDIUM_AMETHYST_BUD");
        names.put(SoundType.f_154658_, "LARGE_AMETHYST_BUD");
        names.put(SoundType.f_154659_, "TUFF");
        names.put(SoundType.f_154660_, "CALCITE");
        names.put(SoundType.f_154661_, "DRIPSTONE_BLOCK");
        names.put(SoundType.f_154662_, "POINTED_DRIPSTONE");
        names.put(SoundType.f_154663_, "COPPER");
        names.put(SoundType.f_154664_, "CAVE_VINES");
        names.put(SoundType.f_154665_, "SPORE_BLOSSOM");
        names.put(SoundType.f_154666_, "AZALEA");
        names.put(SoundType.f_154667_, "FLOWERING_AZALEA");
        names.put(SoundType.f_154668_, "MOSS_CARPET");
        names.put(SoundType.f_154669_, "MOSS");
        names.put(SoundType.f_154670_, "BIG_DRIPLEAF");
        names.put(SoundType.f_154671_, "SMALL_DRIPLEAF");
        names.put(SoundType.f_154672_, "ROOTED_DIRT");
        names.put(SoundType.f_154673_, "HANGING_ROOTS");
        names.put(SoundType.f_154674_, "AZALEA_LEAVES");
        names.put(SoundType.f_154675_, "SCULK_SENSOR");
        names.put(SoundType.f_222472_, "SCULK_CATALYST");
        names.put(SoundType.f_222473_, "SCULK");
        names.put(SoundType.f_222474_, "SCULK_VEIN");
        names.put(SoundType.f_222475_, "SCULK_SHRIEKER");
        names.put(SoundType.f_154676_, "GLOW_LICHEN");
        names.put(SoundType.f_154677_, "DEEPSLATE");
        names.put(SoundType.f_154678_, "DEEPSLATE_BRICKS");
        names.put(SoundType.f_154679_, "DEEPSLATE_TILES");
        names.put(SoundType.f_154680_, "POLISHED_DEEPSLATE");
        names.put(SoundType.f_222465_, "FROGLIGHT");
        names.put(SoundType.f_222466_, "FROGSPAWN");
        names.put(SoundType.f_222467_, "MANGROVE_ROOTS");
        names.put(SoundType.f_222468_, "MUDDY_MANGROVE_ROOTS");
        names.put(SoundType.f_222469_, "MUD");
        names.put(SoundType.f_222470_, "MUD_BRICKS");
        names.put(SoundType.f_222471_, "PACKED_MUD");
        names.put(SoundType.f_244174_, "HANGING_SIGN");
        names.put(SoundType.f_256908_, "NETHER_WOOD_HANGING_SIGN");
        names.put(SoundType.f_256995_, "BAMBOO_WOOD_HANGING_SIGN");
        names.put(SoundType.f_243772_, "BAMBOO_WOOD");
        names.put(SoundType.f_244244_, "NETHER_WOOD");
        names.put(SoundType.f_271497_, "CHERRY_WOOD");
        names.put(SoundType.f_271370_, "CHERRY_SAPLING");
        names.put(SoundType.f_271239_, "CHERRY_LEAVES");
        names.put(SoundType.f_271094_, "CHERRY_WOOD_HANGING_SIGN");
        names.put(SoundType.f_256956_, "CHISELED_BOOKSHELF");
        names.put(SoundType.f_271168_, "SUSPICIOUS_SAND");
        names.put(SoundType.f_276658_, "SUSPICIOUS_GRAVEL");
        names.put(SoundType.f_271215_, "DECORATED_POT");
        names.put(SoundType.f_276571_, "DECORATED_POT_CRACKED");
        TRANSLATION_MAP = Collections.unmodifiableMap(names);
    }
}

